fid = fopen('trace_log.dat', 'r');
a = fread(fid, 'float32');
fclose(fid);

parameters = a(1); traces=a(2); 
n = floor((length(a)-parameters)/traces);

b = reshape(a(parameters+1:end), traces, n);
t = (b(1,:) - b(1,1))/1e5;
y1 = b(2,:); % in
y2 = b(3,:); % V
y3 = b(4,:); % out
y4 = b(5,:); % out

figure(1)
plot(t, 'g'); hold on;
plot(y1, 'k'); 
plot(y2, 'r'); 
plot(y3, 'b'); 
plot(y4, 'm'); 
hold off
hold off

figure(2)
f1 = subplot(311);
plot(t, y1, 'b'); hold on;
plot(t, y2, 'r'); hold on; 
hold off
f2 = subplot(312);
plot(t, y3, 'k'); hold on; 
hold off

f3 = subplot(313);
plot(t, y4, 'k'); hold on; 

linkaxes([f1,f2,f3], 'x');
